/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.base;

import filenet.vw.api.VWOperationDefinition;
import filenet.vw.api.VWParameterDefinition;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.table.AbstractTableModel;

public class VWConfigOperationTableModel
extends AbstractTableModel {
    private static final int NUM_COLUMNS = 1;
    public static final int COL_NAME = 0;
    public static final int COL_DESCRIPTION = 1;
    private VWQueueDefinition m_queueDefinition = null;
    private JDialog m_parent = null;
    private Vector m_rowData = null;
    private boolean m_bIsModified = false;
    private String m_description = null;

    public VWConfigOperationTableModel(VWQueueDefinition queueDef, JDialog parent) {
        try {
            VWOperationDefinition[] operations;
            this.m_queueDefinition = queueDef;
            this.m_parent = parent;
            this.m_rowData = new Vector();
            if (this.m_queueDefinition != null && (operations = this.m_queueDefinition.getOperations()) != null) {
                for (int nIndex = 0; nIndex < operations.length; ++nIndex) {
                    this.m_rowData.addElement(operations[nIndex]);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public VWOperationDefinition getRowItemAt(int nRowIndex) {
        VWOperationDefinition operationDef = null;
        if (this.m_rowData == null || nRowIndex < 0 || nRowIndex > this.m_rowData.size()) {
            return null;
        }
        if (nRowIndex < this.m_rowData.size()) {
            operationDef = (VWOperationDefinition)this.m_rowData.elementAt(nRowIndex);
        }
        return operationDef;
    }

    public boolean isModified() {
        return this.m_bIsModified;
    }

    public void copyItem(int nRowIndex) {
        VWOperationDefinition operationDef = null;
        VWOperationDefinition newOperationDef = null;
        try {
            String copyOfString;
            operationDef = this.getRowItemAt(nRowIndex);
            if (operationDef != null && (newOperationDef = this.m_queueDefinition.createOperation(copyOfString = VWResource.CopyOf.toString(operationDef.getName()))) != null) {
                newOperationDef.setDescription(operationDef.getDescription());
                VWParameterDefinition[] parameters = operationDef.getParameterDefinitions();
                if (parameters != null) {
                    for (int nIndex = 0; nIndex < parameters.length; ++nIndex) {
                        VWParameterDefinition paramDef = parameters[nIndex];
                        newOperationDef.createParameter(paramDef);
                    }
                }
                this.m_rowData.addElement(newOperationDef);
                this.m_bIsModified = true;
                nRowIndex = this.getRowCount() - 1;
                this.fireTableRowsInserted(nRowIndex, nRowIndex + 1);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_parent, ex.getLocalizedMessage(), 1);
        }
    }

    public void deleteItem(int nRowIndex) {
        VWOperationDefinition operationDef = null;
        try {
            operationDef = this.getRowItemAt(nRowIndex);
            this.m_queueDefinition.deleteOperation(operationDef.getName());
            this.m_rowData.removeElementAt(nRowIndex);
            this.m_bIsModified = true;
            this.fireTableRowsDeleted(nRowIndex, nRowIndex);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_parent, ex.getLocalizedMessage(), 1);
        }
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 1;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return VWResource.Name;
            }
            case 1: {
                return VWResource.Description;
            }
        }
        return null;
    }

    public int getRowCount() {
        if (this.m_rowData != null) {
            return this.m_rowData.size() + 1;
        }
        return 0;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        VWOperationDefinition operationDef = null;
        try {
            operationDef = this.getRowItemAt(nRowIndex);
            switch (nColumnIndex) {
                case 0: {
                    if (operationDef != null) {
                        return operationDef.getName();
                    }
                    return new String();
                }
                case 1: {
                    if (operationDef != null) {
                        return operationDef.getDescription();
                    }
                    return this.m_description;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        return true;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                this.onUpdateName(aValue, nRowIndex);
                break;
            }
            case 1: {
                this.onUpdateDescription(aValue, nRowIndex);
            }
        }
    }

    public void releaseResources() {
        this.m_queueDefinition = null;
        this.m_parent = null;
        if (this.m_rowData != null) {
            this.m_rowData.removeAllElements();
            this.m_rowData = null;
        }
        this.m_description = null;
    }

    private void onUpdateName(Object aValue, int nRowIndex) {
        VWOperationDefinition operationDef = null;
        String newName = null;
        try {
            if (aValue == null || !(aValue instanceof String)) {
                return;
            }
            newName = (String)aValue;
            if (newName.length() == 0) {
                return;
            }
            operationDef = this.getRowItemAt(nRowIndex);
            if (operationDef != null) {
                if (VWStringUtils.compare(newName, operationDef.getName()) != 0) {
                    operationDef.setName(newName);
                }
                this.fireTableCellUpdated(nRowIndex, 0);
            } else {
                operationDef = this.m_queueDefinition.createOperation(newName);
                if (operationDef != null) {
                    operationDef.setDescription(this.m_description);
                    this.m_description = new String();
                    this.m_rowData.addElement(operationDef);
                    this.fireTableRowsInserted(nRowIndex, nRowIndex + 1);
                }
            }
            this.m_bIsModified = true;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            VWMessageDialog.showOptionDialog(this.m_parent, ex.getLocalizedMessage(), 1);
        }
    }

    private void onUpdateDescription(Object aValue, int nRowIndex) {
        VWOperationDefinition operationDef = null;
        try {
            if (aValue == null) {
                return;
            }
            operationDef = this.getRowItemAt(nRowIndex);
            if (operationDef != null) {
                operationDef.setDescription(aValue.toString());
                this.m_bIsModified = true;
            } else {
                this.m_description = aValue.toString();
            }
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

